# Generated by hallucinite on 2021-10-26

from django.db import migrations


def fill_public_profession(apps, schema_editor):
    Profession = apps.get_model('professions', 'Profession')
    PublicProfession = apps.get_model('professions', 'PublicProfession')

    professions = Profession.objects.filter(is_active=True)
    for profession in professions:
        public_profession = PublicProfession.objects.create(
            slug=profession.slug,
            name_ru=profession.name,
            name_en=profession.name_en,
            is_active=profession.is_active,
            position=profession.position,
            professional_sphere=profession.professional_sphere,
        )
        public_profession.professions.add(profession)


def clear_public_profession(apps, schema_editor):
    PublicProfession = apps.get_model('professions', 'PublicProfession')
    PublicProfession.objects.all().delete()


class Migration(migrations.Migration):

    dependencies = [
        ('professions', '0008_profession_group_to_public_profession'),
    ]

    operations = [
        migrations.RunPython(
            code=fill_public_profession,
            reverse_code=clear_public_profession,
        ),
    ]
