from django.db import models
from model_utils.models import TimeStampedModel
from intranet.femida.src.core.managers import ActiveManager
from intranet.femida.src.core.models import I18NLocalizedNameModelMixin


class ProfessionalSphere(I18NLocalizedNameModelMixin, TimeStampedModel):

    localized_fields = (
        'name',
        'description',
    )

    objects = models.Manager()
    active = ActiveManager()

    slug = models.CharField(max_length=255, unique=True, null=True)
    name = models.CharField(max_length=255)
    name_en = models.CharField(max_length=255, null=True)
    description_ru = models.TextField(null=True)
    description_en = models.TextField(null=True)
    position = models.IntegerField(default=0)
    is_active = models.BooleanField(default=True)

    class Meta:
        ordering = ['position']

    def save(self, *args, **kwargs):
        super().save(*args, **kwargs)
        if self.is_active is False:
            self.professions.update(is_active=False)

    def __str__(self):
        return self.name


class Profession(I18NLocalizedNameModelMixin, TimeStampedModel):
    """
    Справочник профессий, синхронизированный с OEBS
    """

    objects = models.Manager()
    active = ActiveManager()

    staff_id = models.CharField(max_length=64, null=True, blank=True)
    slug = models.CharField(max_length=255, unique=True, null=True)
    name = models.CharField(max_length=255)
    name_en = models.CharField(max_length=255, null=True)
    professional_sphere = models.ForeignKey(
        to=ProfessionalSphere,
        on_delete=models.PROTECT,
        related_name='professions'
    )
    startrek_id = models.CharField(max_length=128, null=True, blank=True)
    is_active = models.BooleanField(default=True)
    position = models.IntegerField(default=0)

    class Meta:
        ordering = ['professional_sphere__position', 'position']

    def __str__(self):
        return '{}, {}'.format(self.professional_sphere.name, self.name)

    def propogate_professional_sphere(self):
        """
        Проставить денормализованные professional_sphere в других моделях
        """
        from intranet.femida.src.candidates.models import CandidateProfession
        from intranet.femida.src.vacancies.models import Vacancy

        sphere_id = self.professional_sphere_id
        cand_profs = (
            CandidateProfession.objects
            .filter(profession_id=self.id)
            .exclude(professional_sphere_id=sphere_id)
        )
        cand_profs.update(professional_sphere_id=sphere_id)
        vacancies = (
            Vacancy.unsafe
            .filter(profession_id=self.id)
            .exclude(professional_sphere_id=sphere_id)
        )
        vacancies.update(professional_sphere_id=sphere_id)

    def save(self, *args, **kwargs):
        super().save(*args, **kwargs)
        self.propogate_professional_sphere()
