from django.conf import settings
from django.utils.translation import ugettext_noop as _
from model_utils.choices import Choices

from intranet.femida.src.vacancies.choices import VACANCY_PRO_LEVELS

PUBLICATION_TYPES = Choices(
    ('external', _('publications.type.external')),
    ('internal', _('publications.type.internal')),
    ('hh', _('publications.type.hh')),
)

PUBLICATION_STATUSES = Choices(
    ('draft', _('publications.status.draft')),
    ('published', _('publications.status.published')),
    ('archived', _('publications.status.archived')),
    ('deleted', _('publications.status.deleted')),
)

PUBLICATION_LANGUAGES = Choices(
    ('ru', _('publications.lang.ru')),
    ('en', _('publications.lang.en')),
)

PUBLICATION_URLS_MAP = {
    PUBLICATION_LANGUAGES.ru: settings.JOBS_RU_URL,
    PUBLICATION_LANGUAGES.en: settings.JOBS_COM_URL,
}

VANADIUM_BATCH_STATUSES = Choices(
    'new',
    'progress',
    'succeeded',
    'failed',
    'invalid',
)

VANADIUM_TASK_STATUSES = Choices(
    ('success', 'success', 'success'),
    ('failure', 'failure', 'failure'),
    ('taken-from-cache', 'cache', 'taken-from-cache'),
)

PUBLICATION_PRO_LEVELS = Choices(
    ('junior', _('publications.pro_level.junior')),
    ('middle',  _('publications.pro_level.middle')),
    ('senior', _('publications.pro_level.senior')),
    ('chief',  _('publications.pro_level.chief')),
)

# Соответствие уровней публичных уровням из вакансии
PUBLICATION_TO_VACANCY_PRO_LEVELS_MAP = {
    PUBLICATION_PRO_LEVELS.junior: (VACANCY_PRO_LEVELS.junior,),
    PUBLICATION_PRO_LEVELS.middle: (VACANCY_PRO_LEVELS.middle,),
    PUBLICATION_PRO_LEVELS.senior: (
        VACANCY_PRO_LEVELS.senior,
        VACANCY_PRO_LEVELS.lead,
        VACANCY_PRO_LEVELS.expert,
    )
}
# Соответствие уровней из вакансии уровням публичным
VACANCY_TO_PUBLICATION_PRO_LEVELS_MAP = {}
for pub_pro_level, vac_pro_levels in PUBLICATION_TO_VACANCY_PRO_LEVELS_MAP.items():
    for vac_pro_level in vac_pro_levels:
        VACANCY_TO_PUBLICATION_PRO_LEVELS_MAP[vac_pro_level] = pub_pro_level

VACANCY_TO_PUBLICATION_PRO_LEVELS_DISPLAY_MAP = {
    vac_pro_level: PUBLICATION_PRO_LEVELS[pub_pro_level]
    for vac_pro_level, pub_pro_level in VACANCY_TO_PUBLICATION_PRO_LEVELS_MAP.items()
}

PUBLICATION_EMPLOYMENT_TYPES = Choices(
    ('intern', _('publications.employment_type.intern')),
    ('remote', _('publications.employment_type.remote')),
    ('office', _('publications.employment_type.office')),
)

PUBLICATION_FACETS = Choices(
    'cities',
    'professions',
    'public_professions',
    'services',
    'skills',
    'pro_levels',
    'employment_types'
)

JOBS_SUGGEST_TYPES = Choices(
    PUBLICATION_FACETS.professions,
    PUBLICATION_FACETS.public_professions,
    'db_suggest',
)
