from collections import defaultdict

from django.core.management.base import BaseCommand
from django.db import transaction

from intranet.femida.src.publications.models import Publication
from intranet.femida.src.utils.files import download


class Command(BaseCommand):

    help = 'Move og image from bunker json to og_image field'

    def add_arguments(self, parser):
        parser.add_argument('--dry-run', action='store_true')
        parser.add_argument('--include-filled', action='store_true')

    @transaction.atomic
    def handle(self, *args, **options):
        publications = Publication.objects.filter(bunker_json__isnull=False)

        if not options['include_filled']:
            publications = publications.filter(og_image__isnull=True)

        errors = defaultdict(list)
        for i, publication in enumerate(publications):
            if i % 100 == 0:
                print(f'Processed {i} publications')
            image_url = publication.bunker_json.get('meta', {}).get('metaImage')
            if not image_url:
                errors['missing image'].append(publication.id)
                continue

            image = download(image_url, name='og_image')
            if not image:
                errors['failed to get image'].append(publication.id)
                continue

            publication.og_image = image
            if not options['dry_run']:
                publication.save(update_fields=['og_image'])

        for error_name, publication_ids in errors.items():
            print(f'{len(publication_ids)} errors of type "{error_name}"')
            print('publication ids:', publication_ids, end='\n\n')
