from django.db import models

from intranet.femida.src.publications.choices import PUBLICATION_STATUSES, PUBLICATION_TYPES


class PublicationQuerySet(models.QuerySet):

    def published_external(self):
        return self.filter(
            type=PUBLICATION_TYPES.external,
            status=PUBLICATION_STATUSES.published,
        )


class PublicationSuggestQuerySet(models.QuerySet):

    def active(self):
        return self.filter(is_active=True)


PublicationManager = models.Manager.from_queryset(PublicationQuerySet)
PublicationSuggestManager = models.Manager.from_queryset(PublicationSuggestQuerySet)
