# Generated by Django 2.2.18 on 2021-02-10 14:10

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('services', '0001_initial'),
        ('vacancies', '0014_publicationsubscription_hash_not_nullable'),
    ]

    operations = [
        migrations.CreateModel(
            name='Publication',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('form_id', models.IntegerField(blank=True, null=True)),
                ('type', models.CharField(choices=[('external', 'publications.type.external'), ('internal', 'publications.type.internal'), ('hh', 'publications.type.hh')], max_length=32)),
                (
                    'status',
                    models.CharField(
                        choices=[
                            ('draft', 'publications.status.draft'),
                            ('published', 'publications.status.published'),
                            ('archived', 'publications.status.archived'),
                            ('deleted', 'publications.status.deleted'),
                        ],
                        default='draft',
                        max_length=32,
                    ),
                ),
                ('priority', models.IntegerField(default=0)),
                ('published_at', models.DateField(blank=True, null=True)),
                ('lang', models.CharField(choices=[('ru', 'publications.lang.ru'), ('en', 'publications.lang.en')], max_length=32, default='ru')),
                ('title', models.CharField(max_length=255)),
                ('short_summary', models.TextField(verbose_name='Краткое описание')),
                ('key_qualifications', models.TextField(verbose_name='Мы ждем, что вы')),
                ('additional_requirements', models.TextField(blank=True, verbose_name='Будет плюсом, если вы')),
                ('description', models.TextField(blank=True, verbose_name='Общее описание', )),
                ('public_service', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='publications', to='services.PublicService')),
                ('vacancy', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='publications', to='vacancies.Vacancy')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
