# Generated by Django 2.2.24 on 2021-07-12 09:48
# https://docs.djangoproject.com/en/3.2/howto/writing-migrations/#migrations-that-add-unique-fields

from django.db import migrations
import uuid


def gen_publications_uuid(apps, schema_editor):
    Publication = apps.get_model('publications', 'Publication')
    publications_to_update = []
    for obj in Publication.objects.all():
        obj.uuid = uuid.uuid4()
        publications_to_update.append(obj)
    Publication.objects.bulk_update(
        publications_to_update,
        ['uuid'],
        batch_size=1000,
    )


class Migration(migrations.Migration):

    dependencies = [
        ('publications', '0004_publication_uuid'),
    ]

    operations = [
        migrations.RunPython(gen_publications_uuid, reverse_code=migrations.RunPython.noop),
    ]
