import django.contrib.postgres.fields
import django.utils.timezone
import model_utils.fields

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('publications', '0010_publication_fulltext_search_setup'),
    ]

    operations = [
        migrations.CreateModel(
            name='PublicationFacet',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'created',
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='created',
                    ),
                ),
                (
                    'modified',
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='modified',
                    ),
                ),
                (
                    'facet',
                    models.CharField(
                        choices=[
                            ('cities', 'cities'),
                            ('professions', 'professions'),
                            ('services', 'services'),
                            ('skills', 'skills'),
                            ('pro_levels', 'pro_levels'),
                        ],
                        help_text='Фасет фильтрации',
                        max_length=32,
                    ),
                ),
                ('value', models.CharField(help_text='Slug/ID значения фасета', max_length=255)),
                (
                    'lang',
                    models.CharField(
                        choices=[('ru', 'publications.lang.ru'), ('en', 'publications.lang.en')],
                        help_text='Язык',
                        max_length=2,
                    ),
                ),
                (
                    'publication_ids',
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.IntegerField(),
                        default=list,
                        help_text='Список подходящих под значение фасета публикаций',
                        size=None,
                    ),
                ),
            ],
        ),
        migrations.AddConstraint(
            model_name='PublicationFacet',
            constraint=models.UniqueConstraint(
                fields=['facet', 'value', 'lang'],
                name='unique_publications_filter_index_fields',
            ),
        ),
    ]
