from django.contrib import admin

from . import models


class PublicServiceAdmin(admin.ModelAdmin):

    search_fields = (
        'name_ru',
        'name_en',
    )
    list_display = (
        'name_ru',
        'name_en',
        'is_active',
    )
    list_editable = (
        'is_active',
    )


admin.site.register(models.PublicService, PublicServiceAdmin)
