from django.conf import settings
from django.core.management.base import BaseCommand
from django.db import transaction

from intranet.femida.src.services.models import PublicService
from intranet.femida.src.utils.files import download


class Command(BaseCommand):

    help = 'Reupload icons from mds namespace to public s3 bucket'

    def add_arguments(self, parser):
        parser.add_argument('--dry-run', action='store_true')

    @transaction.atomic
    def handle(self, *args, **options):
        public_services = PublicService.objects.all()
        for service in public_services:
            url = f'{settings.MDS_HOST}/get-femida/{service.icon.name}'
            image = download(url, name='icon')
            if not image:
                print('failed to update image for service', service.name)
                continue
            service.icon = image

            if not options['dry_run']:
                service.save()
