from functools import partial

from django.db import models

from intranet.femida.src.attachments.models import upload_to
from intranet.femida.src.core.models import I18NModelMixin
from intranet.femida.src.utils.s3 import S3Storage


class PublicService(I18NModelMixin, models.Model):
    """
    Сервис, известный за пределами Яндекса (Еда, Такси, Карты и т.д.).
    Используется на сайте вакансий. Не путать с ABC-сервисами (staff.Service)
    """
    localized_fields = (
        'name',
        'description',
    )

    name_ru = models.CharField(max_length=255)
    name_en = models.CharField(max_length=255)
    slug = models.CharField(max_length=255, unique=True, null=True)
    description_ru = models.TextField()
    description_en = models.TextField()
    icon = models.FileField(
        upload_to=partial(upload_to, prefix='public_services'),
        storage=S3Storage(),
        max_length=512,
    )
    is_active = models.BooleanField(default=True)

    def __str__(self):
        return f'Public Service {self.id} ({self.slug}): {self.name_en}'
