from django.utils.translation import ugettext_noop as _

from model_utils import Choices


DEPARTMENT_KINDS = Choices(
    ('direction', _('department.kind.direction')),
    ('division', _('department.kind.division')),
)


# Роли в подразделениях, которые должны автоматом попадать
# в наблюдателей вакансий этого подразделения
DEPARTMENT_AUTO_OBSERVER_ROLES = Choices(
    ('chief', _('department.role.chief')),
    ('hr_partner', _('department.role.hr_partner')),
    ('general_director', _('department.role.general_director')),
)


# Это не все роли из Стаффа, но остальные нам пока не нужны, будем их игнорировать
DEPARTMENT_ROLES = DEPARTMENT_AUTO_OBSERVER_ROLES + Choices(
    ('hr_analyst_temp', 'hr_analyst', _('department.role.hr_analyst')),
    ('recruitment_partner', _('department.role.recruitment_partner')),
)

DEPARTMENT_TAGS = Choices(
    ('business_unit', _('department.tags.business_unit')),
    ('experiment', _('department.tags.experiment')),
)

BP_REGISTRY_REQUEST_TYPE = Choices(
    ('vacancy', 'Вакансия'),
    ('internal_offer', 'Внутренний оффер'),
    ('offer', 'Оффер'),
    ('offer_rejection', 'Отказ от оффера'),
    ('vacancy_cancellation', 'Аннулирование вакансии'),
    ('bp_assignment_creation', 'Создание назначения'),
)


GEOGRAPHY_KINDS = Choices(
    ('international', 'Международка'),
    ('rus', 'СНГ'),
)
