from typing import Dict, Iterator

from intranet.femida.src.candidates.choices import CONTACT_TYPES
from intranet.femida.src.candidates.contacts import normalize_phone


CONTACT_TYPE_MAP = {
    'skype': CONTACT_TYPES.skype,
    'telegram': CONTACT_TYPES.telegram,
    'vkontakte': CONTACT_TYPES.vk,
    'facebook': CONTACT_TYPES.facebook,
    'github': CONTACT_TYPES.github,
    'personal_email': CONTACT_TYPES.email,
    'gmail': CONTACT_TYPES.email,
}


def fetch_contacts_from_person(person: Dict) -> Iterator[Dict]:
    for phone in person['phones']:
        account_id = phone['number']
        normalized_account_id = normalize_phone(account_id)
        if normalized_account_id:
            yield {
                'type': CONTACT_TYPES.phone,
                'account_id': normalized_account_id,
            }

    for account in person['accounts']:
        if account['type'] not in CONTACT_TYPE_MAP:
            continue
        yield {
            'type': CONTACT_TYPE_MAP[account['type']],
            'account_id': account['value'].lower(),
        }

    if person['yandex']['login']:
        login = person['yandex']['login'].lower()
        yield {
            'type': CONTACT_TYPES.email,
            'account_id': login if '@' in login else f'{login}@yandex.ru',
        }
