# Generated by Django 1.11.2 on 2018-08-20 19:08
import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion
import intranet.femida.src.core.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('core', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Department',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.CharField(max_length=255)),
                ('name', models.CharField(max_length=255)),
                ('group_id', models.IntegerField()),
                ('is_deleted', models.BooleanField(default=False)),
                ('ancestors', django.contrib.postgres.fields.ArrayField(base_field=models.IntegerField(), default=list, size=None)),
            ],
            options={
                'db_table': 'departments_department',
            },
        ),
        migrations.CreateModel(
            name='DepartmentUser',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('role', models.CharField(
                    choices=[
                        ('chief', 'department.role.chief'),
                        ('hr_partner', 'department.role.hr_partner'),
                        ('general_director', 'department.role.general_director'),
                        ('hr_analyst_temp', 'department.role.hr_analyst'),
                        ('recruitment_partner', 'department.role.recruitment_partner'),
                    ],
                    max_length=32,
                )),
                ('is_direct', models.BooleanField(default=False)),
                ('department', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='department_users', to='staff.Department')),
            ],
            options={
                'db_table': 'departments_departmentuser',
            },
        ),
        migrations.CreateModel(
            name='Office',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name_ru', models.CharField(max_length=255)),
                ('name_en', models.CharField(max_length=255)),
                ('address_ru', models.CharField(max_length=255)),
                ('address_en', models.CharField(max_length=255)),
                ('is_deleted', models.BooleanField(default=False)),
                ('city', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='core.City')),
            ],
            options={
                'db_table': 'offices_office',
            },
            bases=(intranet.femida.src.core.models.I18NModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name='Organization',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('is_deleted', models.BooleanField(default=False)),
                ('startrek_id', models.CharField(blank=True, max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='Service',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.CharField(max_length=255)),
                ('name', models.CharField(max_length=255)),
                ('group_id', models.IntegerField()),
                ('is_deleted', models.BooleanField(default=False)),
            ],
            options={
                'db_table': 'services_service',
            },
        ),
        migrations.CreateModel(
            name='StaffSync',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('synced_at', models.DateTimeField()),
            ],
        ),
    ]
