from rest_framework import serializers

from intranet.femida.src.staff.models import Organization


class BPRegistryIssueSerializer(serializers.Serializer):
    """
    Сериализатор тикета для отправки в реестр БП
    """
    budget_position_id = serializers.SerializerMethodField()
    review_scheme_translation_id = serializers.ReadOnlyField(source='reviewScheme2.id')
    bonus_scheme_translation_id = serializers.ReadOnlyField(source='bonusScheme2.id')
    compensation_scheme_translation_id = serializers.ReadOnlyField(source='compensationScheme2.id')
    geography_translation_id = serializers.ReadOnlyField(source='geography2.id')
    hr_product_translation_id = serializers.ReadOnlyField(source='productHr2.id')
    office = serializers.ReadOnlyField(source='newOffice.id')
    dismissal_date = serializers.ReadOnlyField(source='quitDate')
    salary = serializers.SerializerMethodField()
    currency = serializers.SerializerMethodField()
    grade = serializers.ReadOnlyField(source='totalVacancyLevel')
    organization = serializers.SerializerMethodField()

    def get_budget_position_id(self, obj):
        bp_id = int(obj.bpNumber)
        return None if bp_id == -1 else bp_id

    @staticmethod
    def get_part_of_salary_field(obj, part_number):
        # Пока поле текстовое и имеет вид "100000 RUB (Рубль)" или то, что введет аналитик
        if obj.maxSalary:
            salary_values = obj.maxSalary.split()
            if len(salary_values) > part_number:
                return salary_values[part_number]
            else:
                return None

    def get_salary(self, obj):
        return self.get_part_of_salary_field(obj, 0)

    def get_currency(self, obj):
        return self.get_part_of_salary_field(obj, 1)

    def get_organization(self, obj):
        if not obj.legalEntity2:
            return None
        org = Organization.objects.filter(name=obj.legalEntity2.value['ru']).first()
        return org and org.id
