import logging
import requests

from django.conf import settings

from intranet.femida.src.core.exceptions import FemidaError
from intranet.femida.src.utils.tvm2_client import get_service_ticket


class ValueStreamsApiError(FemidaError):
    """
    Стандартная ошибка при походах в ручку стаффа value_streams
    """


logger = logging.getLogger(__name__)


def get_value_streams():
    try:
        response = requests.get(
            url=settings.STAFF_VALUE_STREAMS_URL,
            headers={
                'X-Ya-Service-Ticket': get_service_ticket(settings.TVM_STAFF_CLIENT_ID),
            },
            timeout=settings.STAFF_TIMEOUT,
        )
    except requests.exceptions.RequestException:
        logger.error('Value streams API is not responding')
        raise ValueStreamsApiError('Value streams API is not responding')

    if not response.ok:
        logger.error(
            'Value streams API responded with status %s: %s',
            response.status_code,
            response.content.decode('utf-8'),
        )
        raise ValueStreamsApiError(f'Value streams API wrong status {response.status_code}')

    return response.json()['result']
