import importlib
import logging

from intranet.femida.src.celery_app import app
from intranet.femida.src.startrek.utils import add_comment, update_issue, get_issue


logger = logging.getLogger(__name__)


@app.autoretry_task(max_retries=5)
def update_issue_task(keys, **fields):
    update_issue(keys, **fields)


@app.autoretry_task(max_retries=5)
def add_issue_comment_task(keys, text):
    add_comment(keys, text)


@app.autoretry_task(max_retries=5)
def execute_issue_operation_task(operation_class, key, operation_id=None, **fields):
    from intranet.femida.src.startrek import operations
    operation_class = getattr(operations, operation_class)
    operation = operation_class(key, operation_id)
    if not operation.is_completed:
        operation(**fields)


@app.autoretry_task(max_retries=5)
def tracker_trigger_task(view_name: str, module: str, issue_key: str):
    issue = get_issue(issue_key)
    if not (issue.unique and issue.unique.startswith('FEMIDA_')):
        return

    module = importlib.import_module(module)
    view = getattr(module, view_name)

    instance = view().get_object_in_valid_status(issue_key=issue_key)

    if not instance:
        logger.warning(
            '%s with issue_key=%s has invalid status',
            view.model_class.__name__,
            issue_key,
        )
        return

    view.task.delay(instance.id)
