from intranet.femida.src.applications.helpers import active_applications_query
from intranet.femida.src.interviews.choices import (
    APPLICATION_STATUSES as STATUSES,
    APPLICATION_PROPOSAL_STATUSES as PROPOSAL_STATUSES,
)
from intranet.femida.src.interviews.models import Application
from intranet.femida.src.stats import enums
from intranet.femida.src.stats.fetchers.base import HierarchicReportDataFetcher
from intranet.femida.src.stats.utils import ProfessionUnit


class ActiveApplicationsQueueDataFetcher(HierarchicReportDataFetcher):
    """
    FEMIDA-4967: Очередь активных претендентов
    """
    def collect_data(self):
        queryset = (
            Application.unsafe
            .filter(active_applications_query)
            .values_list(
                'status',
                'proposal_status',
                'vacancy__profession_id',
            )
        )
        for status, proposal_status, profession_id in queryset:
            profession = enums.StatKeys.unknown
            if profession_id:
                profession = ProfessionUnit(profession_id, enums.ProfessionUnitTypes.profession)
            keys = self.get_related_keys((profession,))
            for key in keys:
                self.result[key]['draft'] += int(status == STATUSES.draft)
                self.result[key]['in_progress'] += int(status == STATUSES.in_progress)
                self.result[key]['accepted'] += int(proposal_status == PROPOSAL_STATUSES.accepted)
