class ReportsRegistry:

    def __init__(self):
        self._reports = {}
        self._dictionaries = {}

    def register_report(self, cls):
        assert cls.report_name not in self._reports
        self._reports[cls.report_name] = cls
        return cls

    def register_dictionary(self, cls):
        assert cls.name not in self._dictionaries
        self._dictionaries[cls.name] = cls
        return cls

    @property
    def reports(self):
        return self._reports

    @property
    def dictionaries(self):
        return self._dictionaries

    @property
    def dynamic_dictionaries(self):
        return {k: v for k, v in self.dictionaries.items() if v.is_dynamic}


registry = ReportsRegistry()
register_report = registry.register_report
register_dictionary = registry.register_dictionary

from intranet.femida.src.stats.reports import *  # noqa
from intranet.femida.src.stats.dictionaries import *  # noqa
