"""
Описание всех отчетов: https://wiki.yandex-team.ru/intranet/femida/stats/
"""
from datetime import timedelta
from statface_client.constants import WEEKLY_SCALE

from intranet.femida.src.stats.registry import register_report
from intranet.femida.src.stats.managers import ReportManager
from intranet.femida.src.stats import fetchers


@register_report
class ActionlogReport(ReportManager):

    report_name = 'actionlog'
    title = 'Все действия в Фемиде'
    data_fetcher_class = fetchers.ActionlogDataFetcher


@register_report
class CandidatesFunnel30dReport(ReportManager):

    report_name = 'candidates_funnel'
    title = 'Кандидаты - Воронка за 30 дней'
    delta = timedelta(days=30)
    data_fetcher_class = fetchers.CandidatesFunnelDataFetcher


@register_report
class CandidatesFunnel90dReport(ReportManager):

    report_name = 'candidates_funnel_90'
    config_name = 'candidates_funnel.yaml'
    title = 'Кандидаты - Воронка за 90 дней'
    delta = timedelta(days=90)
    data_fetcher_class = fetchers.CandidatesFunnelDataFetcher


@register_report
class CandidatesQueueReport(ReportManager):
    """
    TODO: Средние
    """
    report_name = 'candidates_queue'
    title = 'Кандидаты - очередь в работе'
    data_fetcher_class = fetchers.CandidatesQueueDataFetcher


@register_report
class CandidateProcessingSpeed30dReport(ReportManager):

    report_name = 'candidate_processing_speed_30d'
    config_name = 'candidate_processing_speed.yaml'
    title = 'Кандидаты – скорость обработки'
    delta = timedelta(days=30)
    data_fetcher_class = fetchers.CandidateProcessingSpeedDataFetcher


@register_report
class CandidateProcessingSpeed90dReport(CandidateProcessingSpeed30dReport):

    report_name = 'candidate_processing_speed_90d'
    delta = timedelta(days=90)


@register_report
class ProposalsConversionReportManager(ReportManager):

    report_name = 'proposals_conversion'
    title = 'Конверсия "предложения" кандидатов'
    delta = timedelta(days=30)
    data_fetcher_class = fetchers.ProposalsConversionDataFetcher


@register_report
class ProposalsFastConversionReportManager(ReportManager):

    report_name = 'proposals_fast_conversion'
    title = 'Быстрая конверсия "предложения" кандидатов'
    delta = timedelta(days=7)
    data_fetcher_class = fetchers.ProposalsFastConversionDataFetcher


@register_report
class DuplicationCasesQueueReport(ReportManager):

    report_name = 'duplication_cases_queue'
    title = 'Дубликаты - очередь'
    data_fetcher_class = fetchers.DuplicationCasesQueueDataFetcher


@register_report
class InterviewersWorkloadReport(ReportManager):

    report_name = 'interviewers_workload'
    title = 'Секции - Загрузка интервьюеров'
    data_fetcher_class = fetchers.InterviewersWorkloadDataFetcher


@register_report
class AAInterviewersReport(ReportManager):

    report_name = 'aa_interviewers_workload'
    data_fetcher_class = fetchers.AAInterviewersDataFetcher


@register_report
class InterviewCounts30dReport(ReportManager):

    report_name = 'interview_counts_30d'
    config_name = 'interview_counts.yaml'
    title = 'Секции - количество проведенных'
    delta = timedelta(days=30)
    data_fetcher_class = fetchers.InterviewCountsDataFetcher


@register_report
class InterviewCounts90dReport(ReportManager):

    report_name = 'interview_counts_90d'
    config_name = 'interview_counts.yaml'
    title = 'Секции - количество проведенных'
    delta = timedelta(days=90)
    data_fetcher_class = fetchers.InterviewCountsDataFetcher


@register_report
class InterviewsProcessingSpeedReport(ReportManager):

    report_name = 'interviews_processing_speed'
    title = 'Скорость обработки секций'
    delta = timedelta(days=30)
    data_fetcher_class = fetchers.InterviewsProcessingSpeedDataFetcher


@register_report
class InterviewsProcessingSpeedDetailedReport(ReportManager):

    report_name = 'interviews_processing_speed_detailed'
    title = 'Скорость обработки секций – детальный'
    delta = timedelta(days=7)
    data_fetcher_class = fetchers.InterviewsProcessingSpeedDetailedDataFetcher


@register_report
class EmployersReportManager(ReportManager):

    report_name = 'OffersCurrentCompany'
    config_name = 'employers.yaml'
    title = 'employers'
    data_fetcher_class = fetchers.EmployersDataFetcher


@register_report
class ExternalHireEfficiency30dReport(ReportManager):

    report_name = 'external_hire_efficiency_30d'
    config_name = 'external_hire_efficiency.yaml'
    title = 'Эффективность рекрутеров по внешнему найму'
    delta = timedelta(days=30)
    data_fetcher_class = fetchers.ExternalHireEfficiencyDataFetcher


@register_report
class ExternalHireEfficiency90dReport(ReportManager):

    report_name = 'external_hire_efficiency_90d'
    config_name = 'external_hire_efficiency.yaml'
    title = 'Эффективность рекрутеров по внешнему найму'
    delta = timedelta(days=90)
    data_fetcher_class = fetchers.ExternalHireEfficiencyDataFetcher


@register_report
class OfferDocsProcessingFunnel7dReport(ReportManager):

    report_name = 'offer_docs_processing_funnel_7d'
    config_name = 'offer_docs_processing_funnel.yaml'
    title = 'Офферы – воронка обработки документов'
    delta = timedelta(days=7)
    data_fetcher_class = fetchers.OfferDocsProcessingFunnelDataFetcher


@register_report
class SubmissionsQueueReport(ReportManager):

    report_name = 'submissions_queue'
    title = 'Отклики - очередь'
    data_fetcher_class = fetchers.SubmissionsQueueDataFetcher


@register_report
class SubmissionsProcessingSpeed30dReport(ReportManager):
    """
    TODO: Среднее  время обработки
    """
    report_name = 'submissions_processing_speed_30d'
    config_name = 'submissions_processing_speed.yaml'
    title = 'Отклики – скорость обработки'
    delta = timedelta(days=30)
    data_fetcher_class = fetchers.SubmissionsProcessingSpeedDataFetcher


@register_report
class VacancyCountsReport(ReportManager):

    report_name = 'vacancy_counts'
    title = 'Вакансии – статистика очереди'
    data_fetcher_class = fetchers.VacancyCountsDataFetcher


@register_report
class VacancyProcessingSpeed30dReport(ReportManager):
    """
    TODO: Медианы
    """
    report_name = 'vacancy_processing_speed_30d'
    config_name = 'vacancy_processing_speed.yaml'
    title = 'Вакансии – скорость обработки'
    delta = timedelta(days=30)
    data_fetcher_class = fetchers.VacancyProcessingSpeedDataFetcher


@register_report
class VacancyProcessingSpeed90dReport(ReportManager):

    report_name = 'vacancy_processing_speed_90d'
    config_name = 'vacancy_processing_speed.yaml'
    title = 'Вакансии – скорость обработки'
    delta = timedelta(days=90)
    data_fetcher_class = fetchers.VacancyProcessingSpeedDataFetcher


@register_report
class VacancyProcessingSpeed180dReport(ReportManager):

    report_name = 'vacancy_processing_speed_180d'
    config_name = 'vacancy_processing_speed.yaml'
    title = 'Вакансии – скорость обработки'
    delta = timedelta(days=180)
    data_fetcher_class = fetchers.VacancyProcessingSpeedDataFetcher


@register_report
class OfferVacancyProcessingSpeed30dReport(ReportManager):

    report_name = 'offer_vacancy_processing_speed_30d'
    config_name = 'offer_vacancy_processing_speed.yaml'
    title = 'Вакансии – скорость обработки'
    delta = timedelta(days=30)
    data_fetcher_class = fetchers.OfferVacancyProcessingSpeedDataFetcher


# FEMIDA-4900: Выключаем пока этот отчет, потому что не влезаем в память
# @register_report
class OfferVacancyProcessingSpeed90dReport(ReportManager):

    report_name = 'offer_vacancy_processing_speed_90d'
    config_name = 'offer_vacancy_processing_speed.yaml'
    title = 'Вакансии – скорость обработки'
    delta = timedelta(days=90)
    data_fetcher_class = fetchers.OfferVacancyProcessingSpeedDataFetcher


# FEMIDA-3778: Выключаем пока этот отчет, потому что не влезаем в память
# @register_report
class OfferVacancyProcessingSpeed180dReport(ReportManager):

    report_name = 'offer_vacancy_processing_speed_180d'
    config_name = 'offer_vacancy_processing_speed.yaml'
    title = 'Вакансии – скорость обработки'
    delta = timedelta(days=180)
    data_fetcher_class = fetchers.OfferVacancyProcessingSpeedDataFetcher


@register_report
class VacanciesDurationReport(ReportManager):

    report_name = 'vacancies_duration'
    title = 'Долгие вакансии'
    data_fetcher_class = fetchers.VacanciesDurationDataFetcher


@register_report
class ConsiderationSourcesToOfferReport(ReportManager):

    report_name = 'consideration_sources_to_offer'
    title = 'Конверсия источников рассмотрения → оффер'
    delta = timedelta(days=30)
    data_fetcher_class = fetchers.ConsiderationSourcesToOfferDataFetcher


@register_report
class ConsiderationSourcesToNoOfferReport(ReportManager):

    report_name = 'consideration_sources_to_no_offer'
    title = 'Конверсия источников рассмотрения → без оффера'
    delta = timedelta(days=30)
    data_fetcher_class = fetchers.ConsiderationSourcesToNoOfferDataFetcher


@register_report
class ConsiderationsQueueReport(ReportManager):

    report_name = 'considerations_queue'
    title = 'Рассмотрения кандидатов - очередь'
    data_fetcher_class = fetchers.ConsiderationsQueueDataFetcher


@register_report
class ActiveApplicationsQueueReport(ReportManager):

    report_name = 'active_applications_queue'
    title = 'Претенденты - очередь активных'
    data_fetcher_class = fetchers.ActiveApplicationsQueueDataFetcher


@register_report
class InterviewEventTimeReport(ReportManager):

    report_name = 'interview_event_time'
    title = 'Секции – с актуальной датой'
    delta = timedelta(days=7)
    data_fetcher_class = fetchers.InterviewEventTimeFetcher


@register_report
class HireOrdersQueueReport(ReportManager):

    report_name = 'hire_orders_queue'
    title = 'Автонайм - очередь заказов'
    data_fetcher_class = fetchers.HireOrdersQueueDataFetcher


@register_report
class HireOrdersProcessingSpeed7dReport(ReportManager):

    report_name = 'hire_orders_processing_speed_7d'
    config_name = 'hire_orders_processing_speed.yaml'
    title = 'Автонайм - скорость обработки'
    scale = WEEKLY_SCALE
    delta = timedelta(days=7)
    data_fetcher_class = fetchers.HireOrdersProcessingSpeedDataFetcher
