PY3_LIBRARY(femida.stats)

OWNER(g:tools-femida)

PEERDIR(
    intranet/femida/src
)

PY_SRCS(
    __init__.py
    choices.py
    dictionaries.py
    enums.py
    fetchers/__init__.py
    fetchers/actionlog.py
    fetchers/applications.py
    fetchers/base.py
    fetchers/candidates.py
    fetchers/considerations.py
    fetchers/duplicates.py
    fetchers/hire_orders.py
    fetchers/interviews.py
    fetchers/offers.py
    fetchers/submissions.py
    fetchers/vacancies.py
    managers.py
    registry.py
    reports.py
    statface.py
    tasks.py
    utils.py
)

RESOURCE_FILES(
    PREFIX intranet/femida/src/stats/

    configs/aa_interviewers_workload.yaml
    configs/actionlog.yaml
    configs/active_applications_queue.yaml
    configs/candidate_processing_speed.yaml
    configs/candidates_funnel.yaml
    configs/candidates_queue.yaml
    configs/consideration_sources_to_no_offer.yaml
    configs/consideration_sources_to_offer.yaml
    configs/considerations_queue.yaml
    configs/duplication_cases_queue.yaml
    configs/employers.yaml
    configs/external_hire_efficiency.yaml
    configs/hire_orders_processing_speed.yaml
    configs/hire_orders_queue.yaml
    configs/interview_counts.yaml
    configs/interview_event_time.yaml
    configs/interviewers_workload.yaml
    configs/interviews_processing_speed.yaml
    configs/interviews_processing_speed_detailed.yaml
    configs/offer_docs_processing_funnel.yaml
    configs/offer_vacancy_processing_speed.yaml
    configs/proposals_conversion.yaml
    configs/proposals_fast_conversion.yaml
    configs/submissions_processing_speed.yaml
    configs/submissions_queue.yaml
    configs/vacancies_duration.yaml
    configs/vacancy_counts.yaml
    configs/vacancy_processing_speed.yaml
)

END()
