from django import template

from intranet.femida.src.core.choices import GENDER_CHOICES
from intranet.femida.src.offers.choices import GENDER


register = template.Library()


@register.simple_tag
def genderize(gender, male, female, neutral=None):
    if gender in (GENDER_CHOICES.male, GENDER.M):
        return male
    elif gender in (GENDER_CHOICES.female, GENDER.F):
        return female
    return neutral or male
