from django import template
from django.conf import settings


if settings.IS_LOCAL:
    def _inflect_fio(fullname, form):
        """
        Mock-заглушка на обращения к сервису склонений
        """
        return fullname
else:
    from intranet.femida.src.utils.inflector import inflect_fio as _inflect_fio


register = template.Library()


@register.filter
def inflect_fio(fullname, form):
    if form is None:
        return fullname
    return _inflect_fio(fullname, form)
