import itertools

from django import template
from django.conf import settings


register = template.Library()


@register.simple_tag
def get_department_chain(department):
    departments_verbose = itertools.chain(
        (a.name for a in department.ancestor_departments),
        ['(({staff_url}departments/{department.url} {department.name}))'.format(
            staff_url=settings.STAFF_URL,
            department=department,
        )],
    )
    return ' / '.join(departments_verbose)


@register.simple_tag
def bp_transaction_url(transaction_id):
    return '{staff_url}admin/budget_position/workflow/{transaction_id}/'.format(
        staff_url=settings.STAFF_OEBS_URL,
        transaction_id=transaction_id,
    )
