from django.template import Library
from django.conf import settings

from intranet.femida.src.candidates.choices import (
    CHALLENGE_RESOLUTIONS_TRANSLATIONS,
    CONSIDERATION_STATUSES,
    CONSIDERATION_RESOLUTIONS_TRANSLATIONS,
    ROTATION_REASONS_TRANSLATIONS,
)
from intranet.femida.src.interviews.choices import (
    APPLICATION_STATUSES_TRANSLATIONS,
    APPLICATION_RESOLUTIONS_TRANSLATIONS,
    INTERVIEW_RESOLUTIONS_TRANSLATIONS,
    INTERVIEW_TYPES_TRANSLATIONS_EXTERNAL,
)
from intranet.femida.src.vacancies.choices import (
    VACANCY_STATUSES_TRANSLATIONS,
    VACANCY_RESOLUTIONS_TRANSLATIONS,
    VACANCY_PRO_LEVELS_TRANSLATIONS,
)
from intranet.femida.src.offers.choices import (
    PAYMENT_TYPES_TRANSLATIONS,
    CITIZENSHIP_TRANSLATIONS,
    GENDER_TRANSLATIONS,
    EMPLOYEE_TYPES_TRANSLATIONS,
    SOURCES_TRANSLATIONS,
)


if settings.IS_LOCAL:
    def _get_offer_contract_type_description(offer):
        """
        Mock-заглушка на описание типа
        """
        return ''
else:
    from intranet.femida.src.offers.helpers import (
        get_offer_contract_type_description as _get_offer_contract_type_description,
    )

register = Library()


@register.filter
def translate_application_status(status):
    return APPLICATION_STATUSES_TRANSLATIONS.get(status)


@register.filter
def translate_application_resolution(resolution):
    return APPLICATION_RESOLUTIONS_TRANSLATIONS.get(resolution)


@register.filter
def translate_consideration_status(status):
    return CONSIDERATION_STATUSES._display_map.get(status)


@register.filter
def translate_consideration_source(source):
    return SOURCES_TRANSLATIONS.get(source)


@register.filter
def translate_consideration_resolution(resolution):
    return CONSIDERATION_RESOLUTIONS_TRANSLATIONS.get(resolution)


@register.filter
def translate_rotation_reason(reason):
    return ROTATION_REASONS_TRANSLATIONS.get(reason)


@register.filter
def translate_vacancy_status(status):
    return VACANCY_STATUSES_TRANSLATIONS.get(status)


@register.filter
def translate_vacancy_resolution(resolution):
    return VACANCY_RESOLUTIONS_TRANSLATIONS.get(resolution)


@register.filter
def translate_pro_level(pro_level_number):
    pro_level_number = int(pro_level_number)
    return VACANCY_PRO_LEVELS_TRANSLATIONS.get(pro_level_number)


@register.filter
def translate_challenge_resolution(resolution):
    return CHALLENGE_RESOLUTIONS_TRANSLATIONS.get(resolution)


@register.filter
def translate_interview_resolution(resolution):
    return INTERVIEW_RESOLUTIONS_TRANSLATIONS.get(resolution)


@register.filter
def translate_interview_type_external(interview_type):
    return INTERVIEW_TYPES_TRANSLATIONS_EXTERNAL.get(interview_type)


@register.filter
def translate_offer_payment_type(payment_type):
    return PAYMENT_TYPES_TRANSLATIONS.get(payment_type)


@register.filter
def translate_offer_citizenship(offer):
    return CITIZENSHIP_TRANSLATIONS.get(offer.profile.citizenship)


@register.filter
def translate_offer_gender(gender):
    return GENDER_TRANSLATIONS.get(gender)


@register.filter
def translate_offer_employee_type(employee_type):
    return EMPLOYEE_TYPES_TRANSLATIONS.get(employee_type)


@register.filter
def get_offer_contract_type_description(offer):
    return _get_offer_contract_type_description(offer)
