from django import template


register = template.Library()


class OnlySpacesNode(template.Node):

    def __init__(self, nodelist):
        self.nodelist = nodelist

    def render(self, context):
        output = self.nodelist.render(context)
        return ' '.join(output.split())


@register.filter
def get_item(dictionary, key):
    return dictionary.get(key)


@register.tag
def onlyspaces(parser, token):
    """
    Заменяет все переходы строк, табы и т.п.
    между `{% onlyspaces %}` и `{% endonlyspaces %}` на пробелы
    """
    nodelist = parser.parse(('endonlyspaces',))
    parser.delete_first_token()
    return OnlySpacesNode(nodelist)
