from django.conf.urls import include, url
from django.contrib import admin

from intranet.femida.src.frontend import views, external_views


urlpatterns = [
    url(r'^idm/', include(('django_idm_api.urls', 'idm'))),
    url(r'^admin/', admin.site.urls),

    # Основной фронт
    url(r'^$', views.IndexView.as_view(bundle='femida')),
    url(
        r'^candidates/(?P<candidate_id>\d+)/interviews/create/?',
        views.IndexView.as_view(bundle='interview-create', bundle_rum_code=3579),
    ),
    url(r'^candidates/create/?', views.CandidateCreateIndexView.as_view()),
    url(
        r'^candidates/(?P<candidate_id>\d+)/?',
        views.CandidateDetailIndexView.as_view(),
        name='candidate-detail',
    ),
    url(
        r'^candidates/dashboard/?',
        views.IndexView.as_view(bundle='candidates-dashboard', bundle_rum_code=4070),
    ),
    url(
        r'^candidates/filter/?',
        views.IndexView.as_view(bundle='candidates-filter', bundle_rum_code=4071),
    ),
    url(r'^candidates/?', views.IndexView.as_view(bundle='candidates', bundle_rum_code=3571)),
    url(r'^interviews/?', views.IndexView.as_view(bundle='interviews', bundle_rum_code=1106)),
    url(
        r'^vacancies/(((?P<vacancy_id>\d+)/edit)|(create))/?',
        views.IndexView.as_view(bundle='position-form', bundle_rum_code=4081),
    ),
    url(r'^vacancies/?', views.IndexView.as_view(bundle='positions', bundle_rum_code=3572)),
    url(r'^offers/?', views.IndexView.as_view(bundle='offers', bundle_rum_code=18)),
    url(r'^submissions/?', views.IndexView.as_view(bundle='submissions', bundle_rum_code=3573)),
    url(r'^problems/?', views.IndexView.as_view(bundle='problems', bundle_rum_code=3575)),
    url(r'^complaints/?', views.IndexView.as_view(bundle='complaints', bundle_rum_code=3576)),
    url(r'^presets/?', views.IndexView.as_view(bundle='presets', bundle_rum_code=3365)),
    url(r'^applications/dashboard/?', views.IndexView.as_view(bundle='main', bundle_rum_code=321)),
    url(r'^applications/?', views.IndexView.as_view(bundle='applications', bundle_rum_code=3577)),
    url(r'^publications/(?P<uuid>[0-9a-z-]{36})/og/?$', views.PublicationOGImageView.as_view()),
    url(r'^publications/?', views.IndexView.as_view(bundle='publications', bundle_rum_code=4067)),

    # Внешний фронт
    url(
        r'^hire/offers/(?P<uid>[0-9a-f]{32})/?$',
        external_views.OfferAcceptIndexView.as_view(),
        name='frontend-external-offers-accept',
    ),
    url(
        r'^hire/preprofiles/(?P<uid>[0-9a-f]{32})/?$',
        external_views.PreprofileIndexView.as_view(),
        name='frontend-external-preprofiles-accept',
    ),

    # API
    url(r'^api/', include(('intranet.femida.src.api.urls', 'api'))),
    url(r'^_api/',
        include(('intranet.femida.src.api.private_urls', 'api'), namespace='private-api')),
    url(r'^hire/api/',
        include(('intranet.femida.src.api.external_urls', 'api'), namespace='external-api')),

    url(r'^', include('django_yauth.urls')),
    url(r'^log/?$', views.ActionLogIndexView.as_view()),
    url(
        r'^st/(?P<key>[a-zA-Z]+-\d+)/?$',
        views.StChangelogIndexView.as_view(),
        name='st-changelog',
    ),

    # Export action
    url(
        r'^export_action/',
        include(('intranet.femida.src.export_action.urls', 'export_action')),
    ),
]
