from hashlib import sha1

from django.core.cache import cache

from intranet.femida.src.utils.translation import get_language


def memoize(seconds=900, cache_prefix=''):

    def inner(f):
        def x(*args, **kwargs):
            raw_key = cache_prefix + str(f.__module__) + str(f.__name__) + str(args) + str(kwargs)
            key = sha1(raw_key.encode('utf-8')).hexdigest()
            result = cache.get(key)
            if not result:
                result = f(*args, **kwargs)
                cache.set(key, result, seconds)
            return result
        return x

    return inner


def method_memoize(seconds=900, memoize_language=True, cache_prefix=''):

    def inner(f):
        def x(self, *args, **kwargs):
            # для self доставать только имя класса, иначе в разных workers разные ключи
            class_name = self.__class__.__name__
            raw_key = cache_prefix + str(f.__module__) + str(f.__name__) + class_name + str(args) + str(kwargs)
            if memoize_language:
                raw_key += get_language()
            key = sha1(raw_key.encode('utf-8')).hexdigest()
            result = cache.get(key)
            if not result:
                result = f(self, *args, **kwargs)
                cache.set(key, result, seconds)
            return result
        return x

    return inner
