class ObjectDict(dict):
    """
    Словарь, который ведёт себя, как объект
    """
    def __getattr__(self, item):
        if item not in self:
            raise AttributeError(item)
        return self[item]

    def __setattr__(self, key, value):
        self[key] = value


def get_partial_dict(dictionary, keys):
    return {key: dictionary[key] for key in keys if key in dictionary}
