import difflib


def _get_sign_and_text(chunk):
    sign, text = chunk[0], chunk[2:]
    if sign == '?':
        return None, None
    elif sign == ' ':
        sign = '='
    return sign, text


def get_multiline_strings_diff(a, b):
    delta = difflib.ndiff(a.splitlines(), b.splitlines())
    diff = []

    for chunk in delta:
        sign, text = _get_sign_and_text(chunk)
        if sign:
            diff.append([[sign, text]])

    return diff


def get_oneline_strings_diff(a, b):
    delta = difflib.ndiff(a.split(' '), b.split(' '))
    diff = []

    for chunk in delta:
        sign, text = _get_sign_and_text(chunk)
        if sign:
            diff.append([sign, text])

    return [diff]


def get_strings_diff(a, b):
    is_multiline = '\n' in a or '\n' in b
    return get_multiline_strings_diff(a, b) if is_multiline else get_oneline_strings_diff(a, b)
