import re


QUESTIONS_RGX = re.compile(
    r"""
    (.*?)                   # question
    :*\n
    %{0,2}(.*?)%{0,2}\n\n   # answer
    """,
    re.DOTALL | re.VERBOSE,
)


def parse_forms_wf_questions(raw_questions: str, pattern: re.Pattern = QUESTIONS_RGX):
    """
    Парсит строку вопросов-ответов, в которой испольуется "стартрековское" форматирование
    Дефолтное значение паттерна настроено на стандартную выгрузку вопрос–ответ из конструктора форм.
    Пример https://forms.test.yandex-team.ru/admin/13112/edit
    """
    if not raw_questions:
        return []

    questions = pattern.findall(raw_questions)
    return [{'question': q.strip(), 'answer': a.strip()} for q, a in questions]
