from django.conf import settings
from ids.registry import registry


class GapTypeEnum:

    illness = 'illness'
    maternity = 'maternity'
    vacation = 'vacation'


def _get_gap_repository(oauth_token=settings.FEMIDA_ROBOT_TOKEN):
    return registry.get_repository(
        service='gap2',
        resource_type='gaps',
        user_agent='femida',
        oauth_token=oauth_token,
    )


def get_gaps(usernames, date_from, date_to, **kwargs):
    repo = _get_gap_repository()
    params = dict(
        person_login=usernames,
        date_from=date_from.isoformat(),
        date_to=date_to.isoformat(),
        **kwargs
    )
    return repo.getiter(params)
