import logging

from django.conf import settings
from django.contrib.auth import get_user_model

from ids.registry import registry

from intranet.femida.src.utils.cache import memoize


logger = logging.getLogger(__name__)


msg = 'Could not inflect word "%s" because the following error was occurred.'


User = get_user_model()


class InflectorException(Exception):
    """Базовое исключение инфлектора"""


inflector = registry.get_repository(
    service='inflector',
    resource_type='inflector',
    user_agent='femida',
    oauth_token=settings.FEMIDA_ROBOT_TOKEN,
)


FORM_TO_CASE = {
    1: 'именительный',
    2: 'родительный',
    3: 'дательный',
    4: 'винительный',
    5: 'творительный',
    6: 'предложный',
}


@memoize(60 * 60 * 24)  # one day
def inflect_fio(fullname, form_id):
    """
    Возвращает склоненную строку fullname или оригинал в случае ошибки.
    """
    if not isinstance(fullname, str):
        raise TypeError('Must be str')

    case = FORM_TO_CASE[form_id]
    try:
        return inflector.inflect_person(fullname, case)
    except Exception:
        logger.exception(msg, fullname)
        return fullname
