from intranet.femida.src.utils.translation import get_language


def get_russian_plural_form(number, singular, plural, plural_many):

    if number % 10 == 1 and number != 11:
        return singular
    elif number % 10 in (2, 3, 4) and number % 100 // 10 != 1:
        return plural
    else:
        return plural_many


def get_plural_form(number, singular, plural, plural_many=None, lang=None):

    lang = lang or get_language()
    if lang == 'ru':
        return get_russian_plural_form(number, singular, plural, plural_many)

    return singular if number == 1 else plural
