def queryset_iterator(queryset, chunk_size=1000, from_pk=1):
    assert chunk_size > 0
    queryset = queryset.order_by('pk')

    last_item = queryset.last()
    if last_item is None:
        return
    last_pk = last_item.pk

    pk = from_pk - 1
    while pk < last_pk:
        for row in queryset.filter(pk__gt=pk)[:chunk_size]:
            pk = row.pk
            yield row
