from urllib.parse import urlparse

from django.conf import settings
from storages.backends.s3boto3 import S3Boto3Storage


class S3Storage(S3Boto3Storage):

    def url(self, *args, **kwargs):
        url = super().url(*args, **kwargs)
        path = urlparse(url).path
        return f'{settings.S3_URL}{path}'
