from django.utils.translation import get_language as django_get_language


def get_language(default='ru'):
    return (django_get_language() or default)[:2].lower()


def get_name_field(lang=None):
    if lang is None:
        lang = get_language()
    return 'name_ru' if lang == 'ru' else 'name_en'


def get_localized_name_field(lang=None):
    return get_localized_field('name', lang)


def get_localized_field(field_name, lang=None):
    if lang is None:
        lang = get_language()
    return field_name if lang == 'ru' else f'{field_name}_en'
