import requests

from django.conf import settings
from django.contrib.sites.models import Site


def get_short_url(url):
    return requests.get(
        url='https://nda.ya.ru/--',
        params={
            'url': url,
        },
    ).content


def get_short_femida_url(url):
    current_full_path = '{protocol}://{host}{url}'.format(
        protocol=settings.FEMIDA_PROTOCOL,
        host=Site.objects.get_current().domain,
        url=url,
    )
    return get_short_url(current_full_path)
