import logging

from django.template import loader

from intranet.femida.src.staff.bp_registry import (
    BPRegistryAPI,
    BPRegistryError,
    RewardSchemeRequest,
)
from intranet.femida.src.startrek.operations import IssueCommentOperation
from intranet.femida.src.vacancies.models import Vacancy


logger = logging.getLogger(__name__)


def check_if_reward_category_changed(vacancy: Vacancy, issue):
    try:
        reward_scheme_data = BPRegistryAPI.get_reward_scheme(RewardSchemeRequest(
            department_id=vacancy.department_id,
            occupation_staff_id=vacancy.profession.staff_id,
            budget_position_id=int(issue.bpNumber),
            is_internship=vacancy.is_internship,
            grade_level=None,
            prof_level=vacancy.pro_level_max,
            is_main_work_place=None,
            contract_term=None,
            contract_term_date=None,
        ))

    except BPRegistryError:
        logger.exception('Failed to determine reward category')
        operation = IssueCommentOperation(issue.key)
        operation.delay(loader.render_to_string('startrek/vacancies/bp-registry-failure.wiki'))
        raise

    is_reward_category_changed = reward_scheme_data.get('category_changed', False)
    if not is_reward_category_changed:
        return

    context = {
        'new_reward_category': reward_scheme_data.get('category'),
        'current_reward_category': reward_scheme_data.get('current_category'),
    }
    operation = IssueCommentOperation(issue.key)
    operation.delay(
        loader.render_to_string('startrek/vacancies/category-changed.wiki', context)
    )
