from rest_framework import serializers

from intranet.femida.src.staff.choices import BP_REGISTRY_REQUEST_TYPE
from intranet.femida.src.offers.choices import PAYMENT_TYPES
from intranet.femida.src.startrek.utils import SalarySystemEnum
from intranet.femida.src.core.serializers import MapperField
from intranet.femida.src.vacancies.models import Vacancy


# Note: мы сейчас не храним у себя "Систему оплаты труда" на вакансии.
# Храним только сериализованное значение для тикета JOB.
# Надо начать хранить явно, но перед этим стоит привести
# к общему виду 2 идентичных набора значений.
# Один используется в вакансиях - WAGE_SYSTEM_TYPES,
# другой в офферах - PAYMENT_TYPES.
PAYMENT_TYPES_REVERSE_MAP = {
    SalarySystemEnum.fixed: PAYMENT_TYPES.monthly,
    SalarySystemEnum.piecework: PAYMENT_TYPES.piecework,
    SalarySystemEnum.hourly: PAYMENT_TYPES.hourly,
}


class BPRegistryVacancySerializer(serializers.ModelSerializer):
    """
    Сериализатор вакансии для отправки в реестр БП
    """
    vacancy = serializers.ReadOnlyField(source='id')
    vacancy_name = serializers.ReadOnlyField(source='name')
    job_issue_key = serializers.ReadOnlyField(source='startrek_key')
    payment_type = MapperField(
        mapping=PAYMENT_TYPES_REVERSE_MAP,
        source='issue_data.fields.salarySystem',
    )
    profession = serializers.ReadOnlyField(source='profession.startrek_id')
    profession_key = serializers.ReadOnlyField(source='profession.staff_id')
    professional_level = serializers.ReadOnlyField(source='pro_level_max')
    request_type = serializers.SerializerMethodField()

    def get_request_type(self, obj):
        return BP_REGISTRY_REQUEST_TYPE.vacancy

    class Meta:
        model = Vacancy
        fields = (
            'budget_position_id',
            'vacancy',
            'vacancy_name',
            'job_issue_key',
            'profession',
            'profession_key',
            'professional_level',
            'department',
            'abc_services',
            'payment_type',
            'request_type',
            'is_internship',
        )


class BPRegistryVacancyCancellationSerializer(serializers.ModelSerializer):
    """
    Сериализатор для отправки аннулирования вакансии в реестр БП
    """
    vacancy = serializers.ReadOnlyField(source='id')
    job_issue_key = serializers.ReadOnlyField(source='startrek_key')
    request_type = serializers.SerializerMethodField()

    def get_request_type(self, obj):
        return BP_REGISTRY_REQUEST_TYPE.vacancy_cancellation

    class Meta:
        model = Vacancy
        fields = (
            'budget_position_id',
            'job_issue_key',
            'vacancy',
            'department',
            'request_type',
        )
