from django.utils.translation import ugettext_noop as _

from model_utils import Choices

from intranet.femida.src.core.choices import get_partial_choices

VACANCY_TYPES = Choices(
    ('new', _('vacancy.type.new')),
    ('replacement', _('vacancy.type.replacement')),
    ('pool', _('vacancy.type.pool')),
    ('internship', _('vacancy.type.internship')),
    ('autohire', _('vacancy.type.autohire')),
)


ACTIVE_VACANCY_STATUSES = Choices(
    ('in_progress', _('vacancy.status.in_progress')),
    ('offer_processing', _('vacancy.status.offer_processing')),
)


OPEN_VACANCY_STATUSES = ACTIVE_VACANCY_STATUSES + Choices(
    ('draft', _('vacancy.status.draft')),
    ('on_approval', _('vacancy.status.on_approval')),
    ('offer_accepted', _('vacancy.status.offer_accepted')),
    ('suspended', _('vacancy.status.suspended')),
)

CLOSED_VACANCY_STATUSES = Choices(
    ('closed', _('vacancy.status.closed')),
)

VACANCY_STATUSES = OPEN_VACANCY_STATUSES + CLOSED_VACANCY_STATUSES


VACANCY_FILTER_FORM_STATUSES = Choices(
    ('open', _('vacancy.filter_form.status.open')),
) + get_partial_choices(
    VACANCY_STATUSES,
    VACANCY_STATUSES.in_progress,
    VACANCY_STATUSES.suspended,
    VACANCY_STATUSES.offer_processing,
    VACANCY_STATUSES.on_approval,
    VACANCY_STATUSES.offer_accepted,
    VACANCY_STATUSES.closed,
)

# Статусы вакансий, в которых можно добавлять кандидатов при обработке откликов
ACTIVE_VACANCY_STATUSES_FOR_SUBMISSION = ACTIVE_VACANCY_STATUSES + get_partial_choices(
    VACANCY_STATUSES,
    VACANCY_STATUSES.suspended,
    VACANCY_STATUSES.offer_accepted,
)

VACANCY_STATUSES_TRANSLATIONS = {
    VACANCY_STATUSES.draft: 'Черновик',
    VACANCY_STATUSES.on_approval: 'На согласовании',
    VACANCY_STATUSES.in_progress: 'В работе',
    VACANCY_STATUSES.suspended: 'Приостановлена',
    VACANCY_STATUSES.offer_processing: 'Делается оффер',
    VACANCY_STATUSES.offer_accepted: 'Оффер принят',
    VACANCY_STATUSES.closed: 'Закрыта',
}


MANAGEABLE_VACANCY_RESOLUTIONS = Choices(
    ('cancelled', _('vacancy.resolution.cancelled')),
)


VACANCY_RESOLUTIONS = Choices(
    ('unapproved', _('vacancy.resolution.unapproved')),
    ('rotation', _('vacancy.resolution.rotation')),
    ('hire', _('vacancy.resolution.hire')),
    ('move', _('vacancy.resolution.move')),
    ('intern_transfer', _('vacancy.resolution.intern_transfer')),
) + MANAGEABLE_VACANCY_RESOLUTIONS


VACANCY_RESOLUTIONS_TRANSLATIONS = {
    VACANCY_RESOLUTIONS.unapproved: 'Не подтверждена',
    VACANCY_RESOLUTIONS.cancelled: 'Аннулирована',
    VACANCY_RESOLUTIONS.rotation: 'Ротация',
    VACANCY_RESOLUTIONS.hire: 'Внешний найм',
    VACANCY_RESOLUTIONS.move: 'Перевод',
    VACANCY_RESOLUTIONS.intern_transfer: 'Перевод стажёра',
}


VACANCY_PRIORITIES = Choices(
    ('normal', _('vacancy.priority.normal')),
    ('critical', _('vacancy.priority.critical')),
)

VACANCY_ROLES = Choices(
    ('main_recruiter', _('vacancy.role.main_recruiter')),
    ('recruiter', _('vacancy.role.recruiter')),
    ('hiring_manager', _('vacancy.role.hiring_manager')),
    ('head', _('vacancy.role.head')),
    ('responsible', _('vacancy.role.responsible')),
    ('interviewer', _('vacancy.role.interviewer')),
    ('observer', _('vacancy.role.observer')),
    # Эта роль не управляется через интерфейс,
    # а автоматически синхронизируется на основе DepartmentUser
    ('auto_observer', _('vacancy.role.auto_observer')),
)


VACANCY_FILTER_FORM_ROLES = get_partial_choices(
    VACANCY_ROLES,
    VACANCY_ROLES.hiring_manager,
    VACANCY_ROLES.head,
    VACANCY_ROLES.responsible,
    VACANCY_ROLES.interviewer,
    VACANCY_ROLES.observer,
    VACANCY_ROLES.auto_observer,
)


VACANCY_REPLACEMENT_REASONS = Choices(
    ('rotation', _('vacancy.replacement_reason.rotation')),
    ('dismissal', _('vacancy.replacement_reason.dismissal')),
    ('maternity_leave', _('vacancy.replacement_reason.maternity_leave')),
)


VACANCY_PRO_LEVELS = Choices(
    (1, 'intern', _('vacancy.pro_level.intern')),
    (2, 'junior', _('vacancy.pro_level.junior')),
    (3, 'middle', _('vacancy.pro_level.middle')),
    (4, 'senior', _('vacancy.pro_level.senior')),
    (5, 'lead', _('vacancy.pro_level.lead')),
    (6, 'expert', _('vacancy.pro_level.expert')),
)


VACANCY_PRO_LEVELS_TRANSLATIONS = {
    VACANCY_PRO_LEVELS.intern: 'Стажёр',
    VACANCY_PRO_LEVELS.junior: 'Младший',
    VACANCY_PRO_LEVELS.middle: 'Специалист',
    VACANCY_PRO_LEVELS.senior: 'Старший',
    VACANCY_PRO_LEVELS.lead: 'Ведущий',
    VACANCY_PRO_LEVELS.expert: 'Эксперт',
}


VACANCY_CONTRACT_TYPES = Choices(
    ('fixed', _('vacancy.contract_type.fixed')),
    ('open', _('vacancy.contract_type.open')),
)


WAGE_SYSTEM_TYPES = Choices(
    ('fixed', _('vacancy.wage_system.fixed')),
    ('piecework', _('vacancy.wage_system.piecework')),
    ('hourly', _('vacancy.wage_system.hourly')),
)

# Note: используется только для того, чтобы матчить c аналогом – PAYMENT_TYPES
WAGE_SYSTEM_EXTENDED_TYPES = WAGE_SYSTEM_TYPES + Choices(
    ('fixed', 'monthly', _('vacancy.wage_system.monthly')),
)


VACANCY_BUDGET_SOURCES = Choices(
    ('unknown', _('vacancy.budget_source.unknown')),
    ('budget_position', _('vacancy.budget_source.budget_position')),
    ('credit', _('vacancy.budget_source.credit')),
)


VACANCY_FIELDS_TRANSLATIONS = {
    'name': 'Название',
    'is_hidden': 'Скрытая',
    'deadline': 'Желаемая дата закрытия',
    'department': 'Подразделение',
    'cities': 'Города',
    'professional_sphere': 'Проф. направление',
    'profession': 'Профессия',
    'pro_level_min': 'Мин. проф. уровень',
    'pro_level_max': 'Макс. проф. уровень',
    'skills': 'Навыки',
    'responsibilities_comment': 'Комментарий к задачам',
    'additional_qualities_comment': 'Комментарий к дополнительным качествам',
    'recommendations_comment': 'Стратегия и рекомендация к подбору',
    'kpi_comment': 'Комментарий к KPI',
    'other_comment': 'Комментарий',
    'publication_title': 'Заголовок внутреннего объявления',
    'publication_content': 'Текст внутреннего объявления',
    'is_published': 'Внутреннее объявление опубликовано',

    'head': 'Непосредственный руководитель',
    'hiring_manager': 'Нанимающий менеджер',
    'main_recruiter': 'Основной рекрутер',
    'recruiters': 'Рекрутеры',
    'interviewers': 'Собеседующие',
    'responsibles': 'Ответственные',
    'observers': 'Наблюдатели',
}


PUBLICATION_ACTIVE_STATUS_LIST = (
    VACANCY_STATUSES.in_progress,
    VACANCY_STATUSES.offer_processing,
    VACANCY_STATUSES.suspended,
)


PUBLICATION_SORTING_TYPES = Choices(
    ('created', _('publication.sorting.created')),
    ('-created', 'created_desc', _('publication.sorting.created_desc')),
)
