from django.core.management.base import BaseCommand

from intranet.femida.src.vacancies.models import Vacancy
from intranet.femida.src.utils.files import iterate_csv


def _format_text(text):
    return '<#\n{}\n#>'.format(text.replace('\r', '').replace('\n', '<br>'))


class Command(BaseCommand):

    help = 'Migrate vacancy publications from Staff'

    def add_arguments(self, parser):
        parser.add_argument('--dry-run', action='store_true')
        parser.add_argument('--input', '-i', action='store', required=True)

    def handle(self, *args, **options):
        reader = iterate_csv(options['input'])

        # Игнорируем заголовки
        headers = next(reader)  # noqa

        data = {
            int(_id): {
                'publication_title': title,
                'publication_content': _format_text(content),
                'is_published': True,
            }
            for _id, title, content in reader if _id.isdigit()
        }

        vacancies = Vacancy.unsafe.filter(id__in=data.keys())

        if not options['dry_run']:
            for vacancy in vacancies:
                vacancy_data = data[vacancy.id]
                fields = list(vacancy_data.keys())
                for field in fields:
                    setattr(vacancy, field, vacancy_data[field])
                vacancy.save(update_fields=fields)

        print(vacancies.count(), 'vacancy publications were synced')
