from django.db import models
from django.utils import timezone


class VacancyQuerySet(models.QuerySet):

    def touch(self):
        return self.update(touched_at=timezone.now())

    def published(self):
        return self.filter(is_published=True)


VacancyManager = models.Manager.from_queryset(VacancyQuerySet)
