import waffle
from django.db import connection

from intranet.femida.src.actionlog.tasks import touch_vacancies_task
from intranet.femida.src.isearch.tasks import bulk_push_vacancies_to_isearch
from intranet.femida.src.staff.choices import DEPARTMENT_AUTO_OBSERVER_ROLES
from intranet.femida.src.vacancies.choices import VACANCY_ROLES, VACANCY_STATUSES, VACANCY_TYPES


def create_auto_observers():
    sql = """INSERT INTO vacancies_vacancymembership
        (vacancy_id, member_id, department_user_id, role, created, modified)
        (
            SELECT DISTINCT v.id, du.user_id, du.id, %(role)s, NOW(), NOW()
            FROM vacancies_vacancy AS v
            JOIN departments_departmentuser AS du ON (
              v.department_id = du.department_id
              AND du.role in %(department_roles)s
            )
            LEFT JOIN vacancies_vacancymembership AS vm ON (
              vm.vacancy_id = v.id
              AND vm.role = %(role)s
              AND vm.department_user_id = du.id
            )
            WHERE vm.id IS NULL
        ) RETURNING vacancy_id;
    """
    with connection.cursor() as cursor:
        cursor.execute(sql, {
            'role': VACANCY_ROLES.auto_observer,
            'department_roles': tuple(DEPARTMENT_AUTO_OBSERVER_ROLES._db_values),
        })
        return cursor.fetchall()


def create_heads():
    if not waffle.switch_is_active('enable_head_sync'):
        return []

    sql = """INSERT INTO vacancies_vacancymembership
        (vacancy_id, member_id, department_user_id, role, created, modified)
        (
            SELECT DISTINCT v.id, du.user_id, du.id, %(role)s, NOW(), NOW()
            FROM vacancies_vacancy AS v
            JOIN departments_departmentuser AS du ON (
              v.department_id = du.department_id
              AND du.role = %(department_role)s
              AND du.is_closest = true
            )
            LEFT JOIN vacancies_vacancymembership AS vm ON (
              vm.vacancy_id = v.id
              AND vm.role = %(role)s
              AND vm.department_user_id = du.id
            )
            WHERE v.status <> %(vacancy_status)s AND v.type <> %(vacancy_type)s AND vm.id IS NULL
        ) RETURNING vacancy_id;
        """
    with connection.cursor() as cursor:
        cursor.execute(sql, {
            'role': VACANCY_ROLES.head,
            'department_role': DEPARTMENT_AUTO_OBSERVER_ROLES.chief,
            'vacancy_status': VACANCY_STATUSES.closed,
            'vacancy_type': VACANCY_TYPES.pool,
        })
        return cursor.fetchall()


def create_vacancy_memberships():
    vacancy_ids = set()
    inserted_count = 0
    for rows in (create_auto_observers(), create_heads()):
        vacancy_ids |= {i[0] for i in rows}
        inserted_count += len(rows)

    vacancy_ids = list(vacancy_ids)
    bulk_push_vacancies_to_isearch.delay(vacancy_ids)
    touch_vacancies_task.delay(vacancy_ids)

    return inserted_count
