# Generated by Django 1.11.2 on 2018-08-20 19:08
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.db.models.manager
import django.utils.timezone
import model_utils.fields

import intranet.femida.src.core.db.fields
from intranet.femida.src.vacancies.models import _vacancy_membership_delete_mode


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('professions', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('staff', '0001_initial'),
        ('skills', '0001_initial'),
        ('core', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='SubmissionForm',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('title', models.CharField(max_length=255)),
                ('url', models.CharField(max_length=255)),
                ('forms_constructor_id', models.IntegerField(blank=True, null=True)),
                ('is_internship', models.BooleanField(default=False)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Vacancy',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=255)),
                ('status', models.CharField(
                    choices=[
                        ('in_progress', 'vacancy.status.in_progress'),
                        ('offer_processing', 'vacancy.status.offer_processing'),
                        ('draft', 'vacancy.status.draft'),
                        ('on_approval', 'vacancy.status.on_approval'),
                        ('offer_accepted', 'vacancy.status.offer_accepted'),
                        ('suspended', 'vacancy.status.suspended'),
                        ('closed', 'vacancy.status.closed'),
                    ],
                    default='draft',
                    max_length=32,
                )),
                ('resolution', models.CharField(
                    blank=True,
                    choices=[
                        ('unapproved', 'vacancy.resolution.unapproved'),
                        ('rotation', 'vacancy.resolution.rotation'),
                        ('hire', 'vacancy.resolution.hire'),
                        ('move', 'vacancy.resolution.move'),
                        ('intern_transfer', 'vacancy.resolution.intern_transfer'),
                        ('cancelled', 'vacancy.resolution.cancelled'),
                    ],
                    default='',
                    max_length=32,
                )),
                ('deadline', models.DateField(blank=True, null=True)),
                ('pro_level_min', models.SmallIntegerField(blank=True, choices=[(1, 'vacancy.pro_level.intern'), (2, 'vacancy.pro_level.junior'), (3, 'vacancy.pro_level.middle'), (4, 'vacancy.pro_level.senior'), (5, 'vacancy.pro_level.lead'), (6, 'vacancy.pro_level.expert')], null=True)),
                ('pro_level_max', models.SmallIntegerField(blank=True, choices=[(1, 'vacancy.pro_level.intern'), (2, 'vacancy.pro_level.junior'), (3, 'vacancy.pro_level.middle'), (4, 'vacancy.pro_level.senior'), (5, 'vacancy.pro_level.lead'), (6, 'vacancy.pro_level.expert')], null=True)),
                ('priority', models.CharField(choices=[('normal', 'vacancy.priority.normal'), ('critical', 'vacancy.priority.critical')], default='normal', max_length=32)),
                ('type', models.CharField(
                    choices=[
                        ('new', 'vacancy.type.new'),
                        ('replacement', 'vacancy.type.replacement'),
                        ('pool', 'vacancy.type.pool'),
                        ('internship', 'vacancy.type.internship'),
                        ('autohire', 'vacancy.type.autohire'),
                    ],
                    default='new',
                    max_length=32,
                )),
                ('budget_position_id', models.IntegerField(blank=True, null=True)),
                ('startrek_key', intranet.femida.src.core.db.fields.StartrekIssueKeyField(blank=True, max_length=32, null=True)),
                ('is_hidden', models.BooleanField(default=False)),
                ('replacement_reason', models.CharField(blank=True, choices=[('rotation', 'vacancy.replacement_reason.rotation'), ('dismissal', 'vacancy.replacement_reason.dismissal'), ('maternity_leave', 'vacancy.replacement_reason.maternity_leave')], default='', max_length=32)),
                ('responsibilities_comment', models.TextField(blank=True, default='')),
                ('additional_qualities_comment', models.TextField(blank=True, default='')),
                ('recommendations_comment', models.TextField(blank=True, default='')),
                ('kpi_comment', models.TextField(blank=True, default='')),
                ('other_comment', models.TextField(blank=True, default='')),
                ('raw_issue_data', models.TextField(default='{}')),
            ],
            options={
                'default_manager_name': 'unsafe',
            },
            managers=[
                ('unsafe', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='VacancyCity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('city', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='vacancy_cities', to='core.City')),
                ('vacancy', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='vacancy_cities', to='vacancies.Vacancy')),
            ],
        ),
        migrations.CreateModel(
            name='VacancyGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=255)),
                ('description', models.TextField(blank=True)),
                ('is_active', models.BooleanField(default=True)),
                ('created_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, related_name='created_vacancy_groups', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'default_manager_name': 'unsafe',
            },
            managers=[
                ('unsafe', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='VacancyGroupMembership',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('member', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='vacancy_group_memberships', to=settings.AUTH_USER_MODEL)),
                ('vacancy_group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='memberships', to='vacancies.VacancyGroup')),
            ],
            options={
                'default_manager_name': 'unsafe',
            },
            managers=[
                ('unsafe', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='VacancyHistory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.CharField(
                    choices=[
                        ('in_progress', 'vacancy.status.in_progress'),
                        ('offer_processing', 'vacancy.status.offer_processing'),
                        ('draft', 'vacancy.status.draft'),
                        ('on_approval', 'vacancy.status.on_approval'),
                        ('offer_accepted', 'vacancy.status.offer_accepted'),
                        ('suspended', 'vacancy.status.suspended'),
                        ('closed', 'vacancy.status.closed'),
                    ],
                    max_length=32,
                )),
                ('resolution', models.CharField(
                    blank=True,
                    choices=[
                        ('unapproved', 'vacancy.resolution.unapproved'),
                        ('rotation', 'vacancy.resolution.rotation'),
                        ('hire', 'vacancy.resolution.hire'),
                        ('move', 'vacancy.resolution.move'),
                        ('intern_transfer', 'vacancy.resolution.intern_transfer'),
                        ('cancelled', 'vacancy.resolution.cancelled'),
                    ],
                    max_length=32,
                )),
                ('changed_at', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False)),
                ('vacancy', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='vacancy_history', to='vacancies.Vacancy')),
            ],
        ),
        migrations.CreateModel(
            name='VacancyMembership',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('role', models.CharField(
                    choices=[
                        ('main_recruiter', 'vacancy.role.main_recruiter'),
                        ('recruiter', 'vacancy.role.recruiter'),
                        ('hiring_manager', 'vacancy.role.hiring_manager'),
                        ('head', 'vacancy.role.head'),
                        ('responsible', 'vacancy.role.responsible'),
                        ('interviewer', 'vacancy.role.interviewer'),
                        ('observer', 'vacancy.role.observer'),
                        ('auto_observer', 'vacancy.role.auto_observer'),
                    ],
                    max_length=32,
                )),
                ('department_user', models.ForeignKey(blank=True, null=True, on_delete=_vacancy_membership_delete_mode, to='staff.DepartmentUser')),
                ('member', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='vacancy_memberships', to=settings.AUTH_USER_MODEL)),
                ('vacancy', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='memberships', to='vacancies.Vacancy')),
            ],
            options={
                'default_manager_name': 'unsafe',
            },
            managers=[
                ('unsafe', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='VacancySkill',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_required', models.BooleanField(default=True)),
                ('skill', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='vacancy_skills', to='skills.Skill')),
                ('vacancy', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='vacancy_skills', to='vacancies.Vacancy')),
            ],
        ),
        migrations.AddField(
            model_name='vacancygroup',
            name='recruiters',
            field=models.ManyToManyField(through='vacancies.VacancyGroupMembership', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='vacancygroup',
            name='vacancies',
            field=models.ManyToManyField(related_name='groups', to='vacancies.Vacancy'),
        ),
        migrations.AddField(
            model_name='vacancy',
            name='cities',
            field=models.ManyToManyField(related_name='vacancies', through='vacancies.VacancyCity', to='core.City'),
        ),
        migrations.AddField(
            model_name='vacancy',
            name='created_by',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, related_name='created_vacancies', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='vacancy',
            name='department',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='vacancies', to='staff.Department'),
        ),
        migrations.AddField(
            model_name='vacancy',
            name='instead_of',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='vacancy',
            name='profession',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='vacancies', to='professions.Profession'),
        ),
        migrations.AddField(
            model_name='vacancy',
            name='professional_sphere',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='professions.ProfessionalSphere'),
        ),
        migrations.AddField(
            model_name='vacancy',
            name='skills',
            field=models.ManyToManyField(related_name='vacancies', through='vacancies.VacancySkill', to='skills.Skill'),
        ),
        migrations.AddField(
            model_name='submissionform',
            name='vacancies',
            field=models.ManyToManyField(blank=True, related_name='submission_forms', to='vacancies.Vacancy'),
        ),
        migrations.AlterUniqueTogether(
            name='vacancyskill',
            unique_together=set([('vacancy', 'skill')]),
        ),
        migrations.AddConstraint(
            model_name='vacancymembership',
            constraint=models.UniqueConstraint(
                condition=models.Q(role__in=('head', 'hiring_manager')),
                fields=('vacancy', 'role'),
                name='vacancies_v_vacancy_a86f7b_partial',
            ),
        ),
        migrations.AddConstraint(
            model_name='vacancymembership',
            constraint=models.UniqueConstraint(
                condition=models.Q(department_user__isnull=True),
                fields=('vacancy', 'member', 'role'),
                name='vacancies_v_vacancy_50937c_partial',
            ),
        ),
        migrations.AddConstraint(
            model_name='vacancymembership',
            constraint=models.UniqueConstraint(
                condition=models.Q(department_user__isnull=False),
                fields=('vacancy', 'member', 'role', 'department_user'),
                name='vacancies_v_vacancy_70a6bd_partial',
            ),
        ),
    ]
