# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2019-01-23 09:53
import json

from django.db import migrations, models

from intranet.femida.src.utils.queryset import queryset_iterator


def migrate_abc_services_from_raw_issue_data(apps, schema_editor):
    Vacancy = apps.get_model('vacancies', 'Vacancy')
    vacancies = Vacancy.unsafe.exclude(raw_issue_data='{}')

    VacancyService = Vacancy.abc_services.through
    vacancy_services = []

    for vacancy in queryset_iterator(vacancies):
        issue_data = json.loads(vacancy.raw_issue_data)
        abc_service_ids = (
            issue_data
            .get('fields', {})
            .get('activity', [])
        )
        for service_id in abc_service_ids:
            vacancy_services.append(
                VacancyService(
                    vacancy=vacancy,
                    service_id=service_id,
                )
            )

    VacancyService.objects.bulk_create(vacancy_services, 1000)


class Migration(migrations.Migration):

    dependencies = [
        ('staff', '0002_departmentuser_user'),
        ('vacancies', '0003_vacancy_history_full_name'),
    ]

    operations = [
        migrations.AddField(
            model_name='vacancy',
            name='abc_services',
            field=models.ManyToManyField(
                blank=True,
                related_name='vacancies',
                to='staff.Service',
            ),
        ),
        migrations.RunPython(
            migrate_abc_services_from_raw_issue_data,
            reverse_code=lambda *x, **y: None,
        ),
    ]
