# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2019-06-25 14:06
from django.db import migrations
from django.db.models import F
from django.conf import settings


def fill_search_vector(apps, schema_editor):
    Vacancy = apps.get_model('vacancies', 'Vacancy')
    vacancies = Vacancy.unsafe.filter(is_published=True)
    vacancies.update(publication_title=F('publication_title'))


def unfill_search_vector(apps, schema_editor):

    pass


class Migration(migrations.Migration):

    dependencies = [
        ('vacancies', '0006_vacancy_search_vector'),
    ]

    operations = [
        # Индекс для полнотекстового поиска
        migrations.RunSQL(
            sql=(
                "CREATE INDEX vacancies_vacancy_full_search_idx "
                "ON vacancies_vacancy "
                "USING GIN (search_vector)"
            ),
            reverse_sql="DROP INDEX IF EXISTS vacancies_vacancy_full_search_idx",
        ),

        # Триггер для автоматического пересчёта поискового вектора
        migrations.RunSQL(
            sql=(
                "CREATE FUNCTION vacancy_update_search_vector() RETURNS trigger AS $$ "
                "begin "
                "  new.search_vector := "
                "    setweight(to_tsvector('{search_config}', cast(new.id as varchar)), 'A') ||"
                "    setweight(to_tsvector('{search_config}', coalesce(new.publication_title,'')), 'B'); "
                "  return new; "
                "end "
                "$$ LANGUAGE plpgsql; "

                "CREATE TRIGGER vacancy_update_search_vector_trigger "
                "BEFORE INSERT OR UPDATE "
                "ON vacancies_vacancy "
                "FOR EACH ROW EXECUTE PROCEDURE vacancy_update_search_vector(); ".format(
                    search_config=settings.PG_TEXT_SEARCH_CONFIG,
                )
            ),
            reverse_sql=(
                "DROP TRIGGER IF EXISTS vacancy_update_search_vector_trigger ON vacancies_vacancy; "
                "DROP FUNCTION IF EXISTS vacancy_update_search_vector(); "
            ),
        ),

        # Первоначальное заполнение вектора
        migrations.RunPython(fill_search_vector, unfill_search_vector),
    ]
