# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2019-10-04 15:03
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        ('staff', '0004_dep_user_is_closest'),
        ('core', '0003_pg_full_text_search_config'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('professions', '0001_initial'),
        ('skills', '0001_initial'),
        ('vacancies', '0008_change_type_of_bp_transaction_id'),
    ]

    operations = [
        migrations.CreateModel(
            name='PublicationSubscription',
            fields=[
                ('id', models.AutoField(
                    auto_created=True,
                    primary_key=True,
                    serialize=False,
                    verbose_name='ID',
                )),
                ('created', model_utils.fields.AutoCreatedField(
                    default=django.utils.timezone.now,
                    editable=False,
                    verbose_name='created',
                )),
                ('modified', model_utils.fields.AutoLastModifiedField(
                    default=django.utils.timezone.now,
                    editable=False,
                    verbose_name='modified',
                )),
                ('text', models.TextField(
                    blank=True,
                    default='',
                )),
                ('external_url', models.CharField(
                    blank=True,
                    max_length=255,
                )),
                ('pro_level_min', models.SmallIntegerField(
                    blank=True,
                    choices=[
                        (1, 'vacancy.pro_level.intern'),
                        (2, 'vacancy.pro_level.junior'),
                        (3, 'vacancy.pro_level.middle'),
                        (4, 'vacancy.pro_level.senior'),
                        (5, 'vacancy.pro_level.lead'),
                        (6, 'vacancy.pro_level.expert'),
                    ],
                    null=True,
                )),
                ('pro_level_max', models.SmallIntegerField(
                    blank=True,
                    choices=[
                        (1, 'vacancy.pro_level.intern'),
                        (2, 'vacancy.pro_level.junior'),
                        (3, 'vacancy.pro_level.middle'),
                        (4, 'vacancy.pro_level.senior'),
                        (5, 'vacancy.pro_level.lead'),
                        (6, 'vacancy.pro_level.expert'),
                    ],
                    null=True,
                )),
                ('only_active', models.BooleanField(
                    default=True,
                )),
                ('abc_services', models.ManyToManyField(
                    blank=True,
                    related_name='_publicationsubscription_abc_services_+',
                    to='staff.Service',
                )),
                ('cities', models.ManyToManyField(
                    blank=True,
                    related_name='_publicationsubscription_cities_+',
                    to='core.City',
                )),
                ('created_by', models.ForeignKey(
                    on_delete=django.db.models.deletion.PROTECT,
                    related_name='publication_subscriptions',
                    to=settings.AUTH_USER_MODEL,
                )),
                ('department', models.ForeignKey(
                    blank=True,
                    null=True,
                    on_delete=django.db.models.deletion.CASCADE,
                    related_name='+',
                    to='staff.Department',
                )),
                ('professions', models.ManyToManyField(
                    blank=True,
                    related_name='_publicationsubscription_professions_+',
                    to='professions.Profession',
                )),
                ('shown_vacancies', models.ManyToManyField(
                    blank=True,
                    related_name='_publicationsubscription_shown_vacancies_+',
                    to='vacancies.Vacancy',
                )),
                ('skills', models.ManyToManyField(
                    blank=True,
                    related_name='_publicationsubscription_skills_+',
                    to='skills.Skill',
                )),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
