# Generated by Django 2.2.24 on 2021-11-10 16:35
import ast

from django.db import migrations
from django.db.models import F
from django.utils import timezone

from intranet.femida.src.utils.queryset import queryset_iterator


def fill_touched_at(apps, schema_editor):
    Vacancy = apps.get_model('vacancies', 'Vacancy')
    TaskResult = apps.get_model('django_celery_results', 'TaskResult')
    Vacancy.unsafe.update(touched_at=F('modified'))

    # Достаем все вакансии, которые отправлялись в Поиск за последнее время,
    # и считаем, что они обновились сейчас
    task_results = TaskResult.objects.filter(
        task_name='intranet.femida.src.isearch.tasks.bulk_push_vacancies_to_isearch',
    )
    vacancy_ids = set()
    for task_result in queryset_iterator(task_results):
        args = ast.literal_eval(task_result.task_args)
        kwargs = ast.literal_eval(task_result.task_kwargs)
        if kwargs.get('vacancy_ids'):
            vacancy_ids.update(kwargs['vacancy_ids'])
        else:
            vacancy_ids.update(args[0])

    vacancies = Vacancy.unsafe.filter(id__in=vacancy_ids)
    vacancies.update(touched_at=timezone.now())


class Migration(migrations.Migration):

    dependencies = [
        ('vacancies', '0017_vacancy_touched_at'),
    ]

    operations = [
        migrations.RunPython(
            code=fill_touched_at,
            reverse_code=migrations.RunPython.noop,
        ),
    ]
