# Generated by Django 2.2.27 on 2022-04-04 12:57

from django.db import migrations, models
import django.db.models.deletion


def create_work_modes(apps, schema_editor):
    """Creates base values."""
    WorkMode = apps.get_model('core', 'WorkMode')

    WorkMode(name_ru='Удаленный', name_en='Remote', slug='remote').save()
    WorkMode(name_ru='Офис', name_en='Office', slug='office').save()
    WorkMode(name_ru='Смешанный', name_en='Mixed', slug='mixed').save()


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0008_workmode'),
        ('vacancies', '0019_vacancy_offices_locations'),
    ]

    operations = [
        migrations.CreateModel(
            name='VacancyWorkMode',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('vacancy', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='vacancy_work_mode', to='vacancies.Vacancy')),
                ('work_mode', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='vacancy_work_mode', to='core.WorkMode')),
            ],
        ),
        migrations.AddField(
            model_name='vacancy',
            name='work_mode',
            field=models.ManyToManyField(related_name='vacancies', through='vacancies.VacancyWorkMode', to='core.WorkMode'),
        ),
        migrations.RunPython(create_work_modes)
    ]
